/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.ritual.types;

import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import wayoftime.bloodmagic.ritual.AreaDescriptor;
import wayoftime.bloodmagic.ritual.EnumRuneType;
import wayoftime.bloodmagic.ritual.IMasterRitualStone;
import wayoftime.bloodmagic.ritual.Ritual;
import wayoftime.bloodmagic.ritual.RitualComponent;
import wayoftime.bloodmagic.ritual.RitualRegister;
import wayoftime.bloodmagic.util.Utils;

@RitualRegister(value="sphere")
public class RitualSphereCreate
extends Ritual {
    public static final String SPHEROID_RANGE = "spheroidRange";
    private boolean cached = false;
    private BlockPos currentPos;

    public RitualSphereCreate() {
        super("ritualSphere", 0, 20000, "ritual.bloodmagic.sphereRitual");
        this.addBlockRange(SPHEROID_RANGE, new AreaDescriptor.Rectangle(new BlockPos(-16, -35, -16), new BlockPos(17, -2, 17)));
        this.setMaximumVolumeAndDistanceOfRange(SPHEROID_RANGE, 0, 32, 70);
    }

    @Override
    public void readFromNBT(CompoundTag tag) {
        super.readFromNBT(tag);
        this.currentPos = new BlockPos(tag.m_128451_("xCoord"), tag.m_128451_("yCoord"), tag.m_128451_("zCoord"));
    }

    @Override
    public void writeToNBT(CompoundTag tag) {
        super.writeToNBT(tag);
        if (this.currentPos != null) {
            tag.m_128405_("xCoord", this.currentPos.m_123341_());
            tag.m_128405_("yCoord", this.currentPos.m_123342_());
            tag.m_128405_("zCoord", this.currentPos.m_123343_());
        }
    }

    @Override
    public void performRitual(IMasterRitualStone masterRitualStone) {
        Level world = masterRitualStone.getWorldObj();
        int currentEssence = masterRitualStone.getOwnerNetwork().getCurrentEssence();
        BlockPos masterPos = masterRitualStone.getMasterBlockPos();
        if (currentEssence < this.getRefreshCost()) {
            masterRitualStone.getOwnerNetwork().causeNausea();
            return;
        }
        AreaDescriptor sphereRange = masterRitualStone.getBlockRange(SPHEROID_RANGE);
        AABB sphereBB = sphereRange.getAABB(masterPos);
        int minX = (int)((double)masterPos.m_123341_() - sphereBB.f_82288_);
        int maxX = (int)(sphereBB.f_82291_ - (double)masterPos.m_123341_()) - 1;
        int minY = (int)((double)masterPos.m_123342_() - sphereBB.f_82289_);
        int maxY = (int)(sphereBB.f_82292_ - (double)masterPos.m_123342_()) - 1;
        int minZ = (int)((double)masterPos.m_123343_() - sphereBB.f_82290_);
        int maxZ = (int)(sphereBB.f_82293_ - (double)masterPos.m_123343_()) - 1;
        double sphereCenterX = (maxX + -minX) / 2;
        double sphereCenterY = (maxY + -minY) / 2;
        double sphereCenterZ = (maxZ + -minZ) / 2;
        int yTeleportOffset = (int)(-sphereCenterY * 2.0);
        double xR = (double)(maxX + minX) / 2.0;
        double yR = (double)(maxY + minY) / 2.0;
        double zR = (double)(maxZ + minZ) / 2.0;
        int j = -minY;
        int i = -minX;
        int k = -minZ;
        if (this.currentPos != null) {
            j = this.currentPos.m_123342_();
            i = this.currentPos.m_123341_();
            k = this.currentPos.m_123343_();
        }
        int checks = 0;
        int maxChecks = 100;
        if (j <= maxY) {
            while (i <= maxX) {
                while (k <= maxZ) {
                    if (++checks >= maxChecks) {
                        this.currentPos = new BlockPos(i, j, k);
                        return;
                    }
                    if (this.checkIfEllipsoid(xR, yR, zR, (double)i - sphereCenterX, (double)j - sphereCenterY, (double)k - sphereCenterZ)) {
                        BlockPos newPos = masterPos.m_142082_(i, j, k);
                        if (world.m_46859_(newPos)) {
                            ++k;
                            continue;
                        }
                        BlockPos swapPos = newPos.m_142082_(0, yTeleportOffset, 0);
                        Utils.swapLocations(world, newPos, world, swapPos);
                        if (world.m_46859_(newPos)) {
                            // empty if block
                        }
                        masterRitualStone.getOwnerNetwork().syphon(masterRitualStone.ticket(this.getRefreshCost()));
                        this.currentPos = new BlockPos(i, j, ++k);
                        return;
                    }
                    ++k;
                }
                ++i;
                k = -minZ;
            }
            i = -minX;
            this.currentPos = new BlockPos(i, ++j, k);
            return;
        }
        masterRitualStone.setActive(false);
    }

    public boolean checkIfEllipsoidShell(double xR, double yR, double zR, double xOff, double yOff, double zOff) {
        if (!this.checkIfEllipsoid(xR, yR, zR, xOff, yOff, zOff)) {
            return false;
        }
        return !this.checkIfEllipsoid(xR, yR, zR, xOff + 1.0, yOff, zOff) || !this.checkIfEllipsoid(xR, yR, zR, xOff - 1.0, yOff, zOff) || !this.checkIfEllipsoid(xR, yR, zR, xOff, yOff + 1.0, zOff) || !this.checkIfEllipsoid(xR, yR, zR, xOff, yOff - 1.0, zOff) || !this.checkIfEllipsoid(xR, yR, zR, xOff, yOff, zOff + 1.0) || !this.checkIfEllipsoid(xR, yR, zR, xOff, yOff, zOff - 1.0);
    }

    public boolean checkIfEllipsoid(double xR, double yR, double zR, double xOff, double yOff, double zOff) {
        float possOffset = 0.5f;
        return xOff * xOff / ((xR + (double)possOffset) * (xR + (double)possOffset)) + yOff * yOff / ((yR + (double)possOffset) * (yR + (double)possOffset)) + zOff * zOff / ((zR + (double)possOffset) * (zR + (double)possOffset)) <= 1.0;
    }

    @Override
    public int getRefreshCost() {
        return 10;
    }

    @Override
    public int getRefreshTime() {
        return 1;
    }

    @Override
    public void gatherComponents(Consumer<RitualComponent> components) {
        this.addRune(components, 1, 0, 1, EnumRuneType.EARTH);
        this.addRune(components, 1, 0, -1, EnumRuneType.EARTH);
        this.addRune(components, -1, 0, 1, EnumRuneType.EARTH);
        this.addRune(components, -1, 0, -1, EnumRuneType.EARTH);
        this.addRune(components, 2, 1, 0, EnumRuneType.EARTH);
        this.addRune(components, 0, 1, 2, EnumRuneType.EARTH);
        this.addRune(components, -2, 1, 0, EnumRuneType.EARTH);
        this.addRune(components, 0, 1, -2, EnumRuneType.EARTH);
        this.addRune(components, 2, 1, 2, EnumRuneType.AIR);
        this.addRune(components, 2, 1, -2, EnumRuneType.AIR);
        this.addRune(components, -2, 1, 2, EnumRuneType.AIR);
        this.addRune(components, -2, 1, -2, EnumRuneType.AIR);
        this.addRune(components, 2, 2, 0, EnumRuneType.FIRE);
        this.addRune(components, 0, 2, 2, EnumRuneType.FIRE);
        this.addRune(components, -2, 2, 0, EnumRuneType.FIRE);
        this.addRune(components, 0, 2, -2, EnumRuneType.DUSK);
    }

    @Override
    public Ritual getNewCopy() {
        return new RitualSphereCreate();
    }
}

